//Source file: H:\middleware\src\Alkindi\Services\Util\RatingSpacePoint.java

package Alkindi.Services.InternalData;

/* 
$Header: RatingSpacePoint.java, 9, 4/26/01 2:36:59 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         4/26/01 2:36:59 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 8    Alkindi Development1.7         4/26/01 1:46:07 PM   Schwartz, Joe   Moved
      to new package.
 7    Alkindi Development1.6         2/16/01 5:50:02 PM   Schwartz, Joe   Fixed
      comments.
 6    Alkindi Development1.5         2/14/01 6:21:42 PM   Schwartz, Joe  
      Changed distance() to instance method. Excludes dimensions where the
      instance has no evaluation.
 5    Alkindi Development1.4         2/13/01 5:54:44 PM   Schwartz, Joe  
      Changed to account for new SparseRatingsArray class, used for base class
      of RatingSpacePoint.
 4    Alkindi Development1.3         1/26/01 5:48:30 PM   Schwartz, Joe  
      Improving efficiency.
 3    Alkindi Development1.2         1/22/01 6:39:16 PM   Schwartz, Joe   Added
      static pointDistance().
 2    Alkindi Development1.1         1/22/01 1:45:55 PM   Schwartz, Joe  
      Completed basic class,
 1    Alkindi Development1.0         1/22/01 12:02:57 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents a point in ratings space where products are the bases and their evaluations are the magnitudes. Contains a mapping of products to evaluations.
 */
public class RatingSpacePoint extends SparseRatingsArray implements Cloneable 
{
	
	public RatingSpacePoint() 
	{
	}
	
	/**
	 * Returns a copy of the this RatingSpacePoint. Makes a shallow copy of the internalMap.
	 * @return A clone of the RatingSpacePoint instance.
	 * @roseuid 3A6C5509034B
	 */
	public java.lang.Object clone() 
	{
		return super.clone();
	}
	
	/**
	 * Returns the number of Product/mean pairs stored in the interal map.
	 * @return int
	 * @roseuid 3A391FF302BF
	 */
	public int numProducts() 
	{
		return size();
	}
	
	/**
	 * Measures the distance beweten two points in ratings space. 
	 * <b>Note:</b> This function uses the products contained in the <b>point1</b> as bases for the calculation. It does <i>not</i> iterate over the products in point2.
	 * 
	 * @param point1
	 * @param point2
	 * @param power The "power" of the dimensionality to use in measuring distance. 
	 * @return float
	 * @roseuid 3A4B660A008C
	 */
	public float distance(final RatingSpacePoint point2, final float power) 
	{
		final String mName="distance";
		sort();
		float diff = 0;
		float power_sum = 0;
		int numRatings = size();
		for (int idx = 0; idx < numRatings; idx ++) {
			ProductRating pr = (ProductRating)internalList.get(idx);
			if (evalData[idx] > 0)  {
				diff = Math.abs(evalData[idx] - point2.getEval(prodData[idx]));
/*			if (pr.evaluation > 0) {
				diff = Math.abs(pr.evaluation - point2.getEval(pr.productID));*/
				power_sum += Math.pow(diff, power);
			}
		}
		
		return (float)Math.pow(power_sum, 1.0 / power);
	}
	
	/**
	 * Constructs an RatingSpacePoint with the given initial internal capacity. The capacity refers to the internal list of product evaluations.
	 * @roseuid 3A6C5A3F0148
	 */
	public RatingSpacePoint(final int capacity) 
	{
		super(capacity);
	}
}
